/****************************************************************************
 *   $Id:: power_profiles.h 24 2010-12-17 05:55:55Z nxp12832                $
 *   Project: NXP LPC11xx software example  
 *
 *   Description:
 *     Power API Header File for NXP LPC11Uxx Device Series 
 *
 ****************************************************************************
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * products. This software is supplied "AS IS" without any warranties.
 * NXP Semiconductors assumes no responsibility or liability for the
 * use of the software, conveys no license or title under any patent,
 * copyright, or mask work right to the product. NXP Semiconductors
 * reserves the right to make changes in the software without
 * notification. NXP Semiconductors also make no representation or
 * warranty that such application will be suitable for the specified
 * use without further testing or modification.
****************************************************************************/

#ifndef _POWER_PROFILES_H
#define _POWER_PROFILES_H

#include "LPC11xx.h"
#include "power_api.h"

/*	Frequency feed into the system PLL on sys_pllclkin */
#define SYS_PLLCLKIN_FREQ	12000000UL

#define LPC11xxL

#ifdef LPC11xxL
	#define DELAY_SET_POWER for(i=0;i< (profile->current_system_clock / 10000);i++)
#else
	#define DELAY_SET_POWER
#endif

typedef struct _POWER_PROFILE {
	uint32_t new_system_clock;
	uint32_t current_system_clock;
	uint32_t power_mode;
}POWER_PROFILE;

/*
 *	Sample power profiles API wrapper function.
 *
 *	This function will configure the system pll and power configuration using the
 *	power profiles API. This function serves as a SAMPLE implemention only. 
 *
 *	Parmeter 0:		New desired clock frequency in Hz (e.g. 12000000UL for 12Mhz)
 *	Parmeter 1:		A pointer to a variable that contains the current system frequency.
 *					This function will modify the contents of that variable to the frequency
 *					that was achieved using the set_pll function.
 *					If there was an error in calling the power profiles function, it will
 *					result the variable set to SYS_PLLCLKIN_FREQ, which is the freq feed
 *					into the system pll (sys_pllclkin).
 *	Parameter 2:	Desired mode to be used by the set_power function.
 *
 *	Return:			If there was an error, it will return the error code of either API
 *					function that failed. If successful, it will return 0.
 */
uint32_t config_pll_power(POWER_PROFILE *profile);

#endif /* _POWER_PROFILES_H */
